/*  Validiert und füllt ggf. den vorgegebene Arbeitsgangnummernbereich einer gegebenen ABK.
*/
SELECT tsystem.function__drop_by_regex( 'abk__ab2__range_number__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.abk__ab2__range_number__get(
      _abk_ix             int,
      _start_ab2_id       int DEFAULT null,
      _end_ab2_id         int DEFAULT null,
      _filter_out__a2_ende__true  bool DEFAULT true,  -- Steuert, ob die zurückgegebenen Grenzen des errechneten Bereichs nur NICHT beendete AGe enthalten darf.
      _validate_range     bool DEFAULT true   -- Steuert, ob die ermittelten Grenzen des errechneten Bereichs geprüft werden sollen.
) RETURNS int[] AS $$

DECLARE
    _start_ab2_n int;
    _end_ab2_n int;
BEGIN

    -- returns the min and max a2_n for the given abk which has remaining work to do

    IF _start_ab2_id IS NOT null THEN
        _start_ab2_n := a2_n FROM ab2
                             LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND NOT a2w_marked = -1
                             JOIN ksv ON ks_abt = coalesce(a2w_resource_ks_abt_main_fix, a2_ks)
                            WHERE a2_ab_ix = _abk_ix
                              AND a2_id = _start_ab2_id
                              AND ks_plan;
    ELSE
        _start_ab2_n := min( a2_n )
                             FROM ab2
                             LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND NOT a2w_marked = -1
                             JOIN ksv ON ks_abt = coalesce(a2w_resource_ks_abt_main_fix, a2_ks)
                            WHERE a2_ab_ix = _abk_ix
                              AND (     _filter_out__a2_ende__true IS false -- alle AGs
                                   OR ( a2_ende IS false)
                                   )
                              AND ks_plan;
    END IF;

    IF _end_ab2_id IS NOT null THEN
        _end_ab2_n   := a2_n FROM ab2
                             LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND NOT a2w_marked = -1
                             JOIN ksv ON ks_abt = coalesce(a2w_resource_ks_abt_main_fix, a2_ks)
                            WHERE a2_ab_ix = _abk_ix
                              AND a2_id    = _end_ab2_id
                              AND ks_plan;
    ELSE
        _end_ab2_n := max( a2_n )
                             FROM ab2
                             LEFT JOIN ab2_wkstplan ON a2w_a2_id = a2_id AND NOT a2w_marked = -1
                             JOIN ksv ON ks_abt = coalesce(a2w_resource_ks_abt_main_fix, a2_ks)
                            WHERE a2_ab_ix = _abk_ix
                              AND (     _filter_out__a2_ende__true IS false -- alle AGs
                                   OR ( a2_ende IS false)
                                   )
                              AND ks_plan;
    END IF;


    -- validate ab2 range
    IF _validate_range IS true THEN
        IF
              _end_ab2_n IS NULL
          OR _start_ab2_n IS NULL
          OR _end_ab2_n < _start_ab2_n
        THEN
            RAISE EXCEPTION 'range invalid calculated: abk: %, start: %, %, end: %, %', _abk_ix, _start_ab2_id, _start_ab2_n, _end_ab2_id, _end_ab2_n;
        END IF;
    END IF;

    RETURN array[ _start_ab2_n, _end_ab2_n ];

END $$ LANGUAGE plpgsql STABLE;

